/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.jei;

import cn.foggyhillside.festival_delicacies.jei.JEIPlugin;
import cn.foggyhillside.festival_delicacies.recipe.StoveRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import cn.foggyhillside.festival_delicacies.util.RecipeUtils;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StoveRecipeCategory
implements IRecipeCategory<StoveRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("festival_delicacies", "stove");
    public static final ResourceLocation TEXTURE = new ResourceLocation("festival_delicacies", "textures/gui/pot_stove_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable lit;
    private final IDrawable arrow;
    private final IDrawable containerSlot;
    private final IDrawable pot;

    public StoveRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 86);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.STOVE.get()));
        this.lit = helper.createDrawable(TEXTURE, 176, 17, 14, 18);
        this.arrow = helper.drawableBuilder(TEXTURE, 176, 0, 24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.containerSlot = helper.createDrawable(TEXTURE, 30, 17, 17, 17);
        this.pot = helper.createDrawable(TEXTURE, 176, 35, 15, 15);
    }

    public RecipeType<StoveRecipe> getRecipeType() {
        return JEIPlugin.STOVE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.festival_delicacies.stove");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(StoveRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 89, 35);
        if (recipe.getContainer() != ItemStack.f_41583_) {
            this.containerSlot.draw(guiGraphics, 93, 17);
        }
        if (recipe.getNeedPot().booleanValue()) {
            this.pot.draw(guiGraphics, 94, 54);
        } else {
            this.lit.draw(guiGraphics, 94, 52);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StoveRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 17).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        if (recipe.m_7527_().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 17).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(1)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 66, 17).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(2)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 30, 35).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(3)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 35).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(4)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 66, 35).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(5)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 30, 53).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(6)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 53).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(7)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 8) {
            builder.addSlot(RecipeIngredientRole.INPUT, 66, 53).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(8)).m_43908_()));
        }
        if (recipe.getContainer() != ItemStack.f_41583_) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 93, 17).addItemStack(recipe.getContainer());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 36).addItemStack(RecipeUtils.getResultItem(recipe));
    }
}

